<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$mask = $data['mask'] ?? '';

if (empty($mask)) {
    echo json_encode(['status' => 'error', 'message' => "'mask' parameter is required"]);
    exit;
}

$host = 'localhost';
$dbname = 'hyperfle_sms_server';
$username = 'hyperfle_sms';
$password = 'hy2Per@lex';

try {
    $dsn = "mysql:host=$host;dbname=$dbname";
    $dbh = new PDO($dsn, $username, $password);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Call stored procedure that checks balance only (create one if needed)
    $stmt = $dbh->prepare("CALL check_balance_wa(:sender_id)");
    $stmt->bindParam(':sender_id', $mask, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && isset($result['balance'])) {
        echo json_encode([
            'status' => 'success',
            'mask' => $mask,
            'balance' => $result['balance']
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No balance data found for given mask'
        ]);
    }

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database Error: ' . $e->getMessage()
    ]);
}
