<?php
// Get JSON data from POST request
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Extract parameters from JSON data
$mask = isset($data['mask']) ? $data['mask'] : '';
$text = isset($data['text']) ? $data['text'] : '';
$number = isset($data['number']) ? $data['number'] : '';
$appKey = isset($data['appKey']) ? $data['appKey'] : '';
$authKey = isset($data['authKey']) ? $data['authKey'] : '';
$fileUrl = isset($data['fileUrl']) ? $data['fileUrl'] : '';
$companyID = isset($data['companyID']) ? $data['companyID'] : 'hyperflex';

// Initialize DateTime and other variables
$datetime = new DateTime();
$campaignName = $datetime->format('m/d/Y g:i A');
$clientRef = rand(100000, 999999);

$host = 'localhost';
$dbname = 'hyperfle_sms_server';
$username = 'hyperfle_sms';
$password = 'hy2Per@lex';

try {
    $dsn = "mysql:host=$host;dbname=$dbname";
    $dbh = new PDO($dsn, $username, $password);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Call stored procedure to validate sender
    $stmt = $dbh->prepare("CALL sms_send_single_wa(:sender_id, :sms)");
    $stmt->bindParam(':sender_id', $mask);
    $stmt->bindParam(':sms', $text);
    $stmt->execute();

    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = array('status' => 'error', 'message' => 'No valid customer found');

    foreach ($results as $customer) {
        if ((int)$customer["credit_balance"] > 0 && (int)$customer["current_status"] == 1) {
            error_reporting(E_ALL);
            date_default_timezone_set('Asia/Colombo');

            $curl = curl_init();

            $payload = json_encode([
                'receiver' => $number,
                'isGroup' => 0,
                'message' => [
                    'text' => $text
                ]
            ]);

            curl_setopt_array($curl, array(
                CURLOPT_URL => "http://220.247.243.101:8000/chats/send?id=" . urlencode($companyID),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer A4gx18YGxKAvR01ClcHpcR7TjZUNtwvE",
                    "Content-Type: application/json"
                )
            ));

            $api_response = curl_exec($curl);

            if ($error = curl_error($curl)) {
                $refundStmt = $dbh->prepare("CALL wa_refund(:sender_id)");
                $refundStmt->bindParam(':sender_id', $mask);
                $refundStmt->execute();

                $response = array('status' => 'error', 'message' => 'cURL Error: ' . $error);
            } else {
                $decoded = json_decode($api_response, true);

                if (isset($decoded['success']) && $decoded['success']) {
                    $response = array('status' => 'success', 'message' => 'Message sent', 'response' => $decoded);
                } else {
                    $refundStmt = $dbh->prepare("CALL wa_refund(:sender_id)");
                    $refundStmt->bindParam(':sender_id', $mask);
                    $refundStmt->execute();

                    $response = array('status' => 'error', 'message' => 'API Error', 'response' => $decoded);
                }
            }

            curl_close($curl);
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);

} catch (PDOException $e) {
    $response = array('status' => 'error', 'message' => 'Database Error: ' . $e->getMessage());
    header('Content-Type: application/json');
    echo json_encode($response);
}
